#ifndef __C4DPARTICLEOBJECT_H
#define __C4DPARTICLEOBJECT_H

#include "c4d_baseobject.h"
#include "c4d_basetag.h"

struct BaseParticle
{
	Vector v;
	LONG   count;
};

class Particle
{
	public:
		Vector off,v1,v3;	
		Real   t;       
		LONG   bits;    
};

struct ParticleDetails
{
	Matrix	m;
	Real		lifetime;
};

class ParticleTag : public VariableTag
{
};

class ParticleObject : public BaseObject
{
	public:
		LONG GetParticleCount(void);
		Bool IsMatrixAvailable(void);
		Real GetLifetime(void);

		Particle *GetParticle(ParticleTag *pt, LONG i) { return C4DOS.Bo->PrGetParticle(this,pt,i); }
		ParticleDetails *GetParticleDetails(BaseDocument *doc);
};

static inline Matrix CalcParticleMatrix(Particle *cp)
{
	Matrix m;
	m.v1	= !cp->v1;
	m.v3  = !cp->v3;
	m.v2	= !(m.v3 % m.v1);
	m.off = cp->off;
	return m;
}

#endif
